/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import kiwiapollo.cobblemontrainerbattle.common.SimpleFactory;
import kiwiapollo.cobblemontrainerbattle.global.preset.TrainerStorage;

public class RandomSpawnableTrainerFactory
implements SimpleFactory<String> {
    private final Predicate<String> predicate;

    public RandomSpawnableTrainerFactory() {
        this(t -> true);
    }

    private RandomSpawnableTrainerFactory(Predicate<String> predicate) {
        this.predicate = predicate;
    }

    @Override
    public String create() {
        List<String> trainers = TrainerStorage.getInstance().keySet().stream().filter(this.predicate).filter(this::isSpawningAllowed).toList();
        ArrayList<String> random = new ArrayList<String>(trainers);
        Collections.shuffle(random);
        return (String)random.get(0);
    }

    private boolean isSpawningAllowed(String trainer) {
        try {
            return TrainerStorage.getInstance().get(trainer).isSpawningAllowed();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static class Builder {
        private final List<Predicate<String>> trainers = new ArrayList<Predicate<String>>(List.of(t -> false));

        public RandomSpawnableTrainerFactory build() {
            return new RandomSpawnableTrainerFactory(this.toPredicate());
        }

        private Predicate<String> toPredicate() {
            return this.trainers.stream().reduce(Predicate::or).orElse(t -> true);
        }

        public Builder addAll() {
            this.trainers.add(t -> true);
            return this;
        }

        public Builder addRadicalRed() {
            this.trainers.add(t -> t.matches("^radicalred/.+"));
            return this;
        }

        public Builder addInclementEmerald() {
            this.trainers.add(t -> t.matches("^inclementemerald/.+"));
            return this;
        }

        public Builder addSmogon() {
            this.trainers.add(t -> t.matches("^smogon/.+"));
            return this;
        }
    }
}

